/*
	SuperGif
	https://github.com/buzzfeed/libgif-js
*/

(function(A,w){"function"===typeof define&&define.amd?define([],w):"object"===typeof exports?module.exports=w():A.SuperGif=w()})(this,function(){var A=function(c){return c.reduce(function(b,c){return 2*b+c},0)},w=function(c){for(var b=[],h=7;0<=h;h--)b.push(!!(c&1<<h));return b},M=function(c){this.data=c;this.len=this.data.length;this.pos=0;this.readByte=function(){if(this.pos>=this.data.length)throw Error("Attempted to read past end of stream.");return c instanceof Uint8Array?c[this.pos++]:c.charCodeAt(this.pos++)&
255};this.readBytes=function(b){for(var c=[],d=0;d<b;d++)c.push(this.readByte());return c};this.read=function(b){for(var c="",d=0;d<b;d++)c+=String.fromCharCode(this.readByte());return c};this.readUnsigned=function(){var b=this.readBytes(2);return(b[1]<<8)+b[0]}},G=function(c,b){for(var h=0,d=function(a){for(var c=0,n=0;n<a;n++)b.charCodeAt(h>>3)&1<<(h&7)&&(c|=1<<n),h++;return c},B=[],t=1<<c,a=t+1,f=c+1,e=[],y=function(){e=[];f=c+1;for(var b=0;b<t;b++)e[b]=[b];e[t]=[];e[a]=null},m,g;;)if(g=m,m=d(f),
m===t)y();else{if(m===a)break;if(m<e.length)g!==t&&e.push(e[g].concat(e[m][0]));else{if(m!==e.length)throw Error("Invalid LZW code.");e.push(e[g].concat(e[g][0]))}B.push.apply(B,e[m]);e.length===1<<f&&12>f&&f++}return B},T=function(c,b){b||(b={});var h=function(b){for(var a=[],d=0;d<b;d++)a.push(c.readBytes(3));return a},d=function(){var b="";do{var d=c.readByte();b+=c.read(d)}while(0!==d);return b},B=function(a){var f=function(a){c.readByte();var d=w(c.readByte());a.reserved=d.splice(0,3);a.disposalMethod=
A(d.splice(0,3));a.userInput=d.shift();a.transparencyGiven=d.shift();a.delayTime=c.readUnsigned();a.transparencyIndex=c.readByte();a.terminator=c.readByte();b.gce&&b.gce(a)},e=function(a){a.comment=d();b.com&&b.com(a)},h=function(a){c.readByte();a.ptHeader=c.readBytes(12);a.ptData=d();b.pte&&b.pte(a)},m=function(a){var f=function(a){c.readByte();a.unknown=c.readByte();a.iterations=c.readUnsigned();a.terminator=c.readByte();b.app&&b.app.NETSCAPE&&b.app.NETSCAPE(a)},e=function(a){a.appData=d();b.app&&
b.app[a.identifier]&&b.app[a.identifier](a)};c.readByte();a.identifier=c.read(8);a.authCode=c.read(3);switch(a.identifier){case "NETSCAPE":f(a);break;default:e(a)}},g=function(a){a.data=d();b.unknown&&b.unknown(a)};a.label=c.readByte();switch(a.label){case 249:a.extType="gce";f(a);break;case 254:a.extType="com";e(a);break;case 1:a.extType="pte";h(a);break;case 255:a.extType="app";m(a);break;default:a.extType="unknown",g(a)}},t=function(){var a={};a.sentinel=c.readByte();switch(String.fromCharCode(a.sentinel)){case "!":a.type=
"ext";B(a);break;case ",":a.type="img";a.leftPos=c.readUnsigned();a.topPos=c.readUnsigned();a.width=c.readUnsigned();a.height=c.readUnsigned();var f=w(c.readByte());a.lctFlag=f.shift();a.interlaced=f.shift();a.sorted=f.shift();a.reserved=f.splice(0,2);a.lctSize=A(f.splice(0,3));a.lctFlag&&(a.lct=h(1<<a.lctSize+1));a.lzwMinCodeSize=c.readByte();f=d();a.pixels=G(a.lzwMinCodeSize,f);if(a.interlaced){f=a.pixels;for(var e=a.width,y=Array(f.length),m=f.length/e,g=[0,4,2,1],n=[8,8,4,2],x=0,v=0;4>v;v++)for(var p=
g[v];p<m;p+=n[v]){var C=p,q=f.slice(x*e,(x+1)*e);y.splice.apply(y,[C*e,e].concat(q));x++}a.pixels=y}b.img&&b.img(a);break;case ";":a.type="eof";b.eof&&b.eof(a);break;default:throw Error("Unknown block: 0x"+a.sentinel.toString(16));}"eof"!==a.type&&setTimeout(t,0)};(function(){var a={};a.sig=c.read(3);a.ver=c.read(3);if("GIF"!==a.sig)throw Error("Not a GIF file.");a.width=c.readUnsigned();a.height=c.readUnsigned();var d=w(c.readByte());a.gctFlag=d.shift();a.colorRes=A(d.splice(0,3));a.sorted=d.shift();
a.gctSize=A(d.splice(0,3));a.bgColor=c.readByte();a.pixelAspectRatio=c.readByte();a.gctFlag&&(a.gct=h(1<<a.gctSize+1));b.hdr&&b.hdr(a)})();setTimeout(t,0)};return function(c){var b={vp_l:0,vp_t:0,vp_w:null,vp_h:null,c_w:null,c_h:null};for(D in c)b[D]=c[D];b.vp_w&&b.vp_h&&(b.is_vp=!0);var h,d,B=null,t=!1,a=null,f=null,e=null,y=null,m=null,g=null,n=null,x=!0,v=!1,p=[],C=[],q=b.gif;"undefined"==typeof b.auto_play&&(b.auto_play=!q.getAttribute("rel:auto_play")||"1"==q.getAttribute("rel:auto_play"));var w=
b.hasOwnProperty("on_end")?b.on_end:null,A=b.hasOwnProperty("loop_delay")?b.loop_delay:0,G=b.hasOwnProperty("loop_mode")?b.loop_mode:"auto",H=b.hasOwnProperty("draw_while_loading")?b.draw_while_loading:!0,U=H?b.hasOwnProperty("show_progress_bar")?b.show_progress_bar:!0:!1,V=b.hasOwnProperty("progressbar_height")?b.progressbar_height:25,W=b.hasOwnProperty("progressbar_background_color")?b.progressbar_background_color:"rgba(255,255,255,0.4)",X=b.hasOwnProperty("progressbar_foreground_color")?b.progressbar_foreground_color:
"rgba(255,0,22,.8)",N=function(){f=a=null;m=e;g=e=null},O=function(){try{T(h,Y)}catch(u){I("parse")}},P=function(b,a){r.width=b*k();r.height=a*k();F.style.minWidth=b*k()+"px";z.width=b;z.height=a;z.style.width=b+"px";z.style.height=a+"px";z.getContext("2d").setTransform(1,0,0,1,0,0)},J=function(a,c,d){if(d&&U){d=V;if(b.is_vp)if(v){var u=(b.vp_t+b.vp_h-d)/k();d/=k();var e=b.vp_l/k();a=e+a/c*(b.vp_w/k());c=r.width/k()}else u=b.vp_t+b.vp_h-d,e=b.vp_l,a=e+a/c*b.vp_w,c=r.width;else u=(r.height-d)/(v?k():
1),a=a/c*r.width/(v?k():1),c=r.width/(v?k():1),d/=v?k():1;l.fillStyle=W;l.fillRect(a,u,c-a,d);l.fillStyle=X;l.fillRect(0,u,a,d)}},I=function(a){B=a;d={width:q.width,height:q.height};p=[];l.fillStyle="black";l.fillRect(0,0,b.c_w?b.c_w:d.width,b.c_h?b.c_h:d.height);l.strokeStyle="red";l.lineWidth=3;l.moveTo(0,0);l.lineTo(b.c_w?b.c_w:d.width,b.c_h?b.c_h:d.height);l.moveTo(0,b.c_h?b.c_h:d.height);l.lineTo(b.c_w?b.c_w:d.width,0);l.stroke()},Q=function(){g&&(p.push({data:g.getImageData(0,0,d.width,d.height),
delay:f}),C.push({x:0,y:0}))},E=function(){var a=-1,c=0,d=function(b){a+=b;f()},e=function(){var b=!1,u=function(){null!==w&&w(q);c++;!1!==G||0>c?e():x=b=!1},e=function(){if(b=x){d(1);var c=10*p[a].delay;c||(c=100);0===(a+1+p.length)%p.length?(c+=A,setTimeout(u,c)):setTimeout(e,c)}};return function(){b||setTimeout(e,0)}}(),f=function(){a=parseInt(a,10);if(!p.length)return!1;a>p.length-1&&(a=0);0>a&&(a=0);var b=C[a];z.getContext("2d").putImageData(p[a].data,b.x,b.y);l.globalCompositeOperation="copy";
l.drawImage(z,0,0)};return{init:function(){B||(b.c_w&&b.c_h||l.scale(k(),k()),b.auto_play?e():(a=0,f()))},step:e,play:function(){x=!0;e()},pause:function(){x=!1},playing:x,move_relative:d,current_frame:function(){return a},length:function(){return p.length},move_to:function(b){a=b;f()}}}();c=function(){};var D=function(a,b){return function(c){a(c);J(h.pos,h.data.length,b)}};var Y={hdr:D(function(a){d=a;P(d.width,d.height)}),gce:D(function(b){Q();N();a=b.transparencyGiven?b.transparencyIndex:null;
f=b.delayTime;e=b.disposalMethod}),com:D(c),app:{NETSCAPE:D(c)},img:D(function(c){g||(g=z.getContext("2d"));var e=p.length,f=c.lctFlag?c.lct:d.gct;0<e&&(3===m?null!==y?g.putImageData(p[y].data,0,0):g.clearRect(n.leftPos,n.topPos,n.width,n.height):y=e-1,2===m&&g.clearRect(n.leftPos,n.topPos,n.width,n.height));var u=g.getImageData(c.leftPos,c.topPos,c.width,c.height);c.pixels.forEach(function(b,c){b!==a&&(u.data[4*c]=f[b][0],u.data[4*c+1]=f[b][1],u.data[4*c+2]=f[b][2],u.data[4*c+3]=255)});g.putImageData(u,
c.leftPos,c.topPos);v||(l.scale(k(),k()),v=!0);H&&(l.drawImage(z,0,0),H=b.auto_play);n=c},!0),eof:function(a){Q();J(h.pos,h.data.length,!1);b.c_w&&b.c_h||(r.width=d.width*k(),r.height=d.height*k());E.init();t=!1;K&&K(q)}},R=function(){var a=q.parentNode,c=document.createElement("div");r=document.createElement("canvas");l=r.getContext("2d");F=document.createElement("div");z=document.createElement("canvas");c.width=r.width=q.width;c.height=r.height=q.height;F.style.minWidth=q.width+"px";c.className=
"jsgif";F.className="jsgif_toolbar";c.appendChild(r);c.appendChild(F);a.insertBefore(c,q);a.removeChild(q);b.c_w&&b.c_h&&P(b.c_w,b.c_h);L=!0},k=function(){return b.max_width&&d&&d.width>b.max_width?b.max_width/d.width:1},r,l,F,z,L=!1,K=!1,S=function(a){if(t)return!1;K=a?a:!1;t=!0;p=[];N();n=g=m=y=null;return!0};return{play:E.play,pause:E.pause,move_relative:E.move_relative,move_to:E.move_to,get_playing:function(){return x},get_canvas:function(){return r},get_canvas_scale:function(){return k()},get_loading:function(){return t},
get_auto_play:function(){return b.auto_play},get_length:function(){return E.length()},get_current_frame:function(){return E.current_frame()},load_url:function(a,b){if(S(b)){var c=new XMLHttpRequest;c.open("GET",a,!0);"overrideMimeType"in c?c.overrideMimeType("text/plain; charset=x-user-defined"):"responseType"in c?c.responseType="arraybuffer":c.setRequestHeader("Accept-Charset","x-user-defined");c.onloadstart=function(){L||R()};c.onload=function(a){200!=this.status&&I("xhr - response");"response"in
this||(this.response=(new VBArray(this.responseText)).toArray().map(String.fromCharCode).join(""));a=this.response;0<a.toString().indexOf("ArrayBuffer")&&(a=new Uint8Array(a));h=new M(a);setTimeout(O,0)};c.onprogress=function(a){a.lengthComputable&&J(a.loaded,a.total,!0)};c.onerror=function(){I("xhr")};c.send()}},load:function(a){this.load_url(q.getAttribute("rel:animated_src")||q.src,a)},load_raw:function(a,b){S(b)&&(L||R(),h=new M(a),setTimeout(O,0))},set_frame_offset:function(a,b){C[a]?("undefined"!==
typeof b.x&&(C[a].x=b.x),"undefined"!==typeof b.y&&(C[a].y=b.y)):C[a]=b}}}});






/**
 * lc_gif_player.js - a true Gif Player through SuperGif plugin
 * Version: 1.0
 * Author: Luca Montanari aka LCweb
 * Website: https://lcweb.it
 * Licensed under the MIT license
 */
 
(function() {
	
	/* TODO: on fullscreen switch, keep the viewed frame */
	
	lcgp_count = 0;
	lcgp_instances = [];
	lcgp_cont_move = [];
	lcgp_init_intval = [];
	
	lc_gif_player = function(gif_selector) {
		var objs = document.querySelectorAll(gif_selector);
		
		for (var i = 0, obj; obj = objs[i]; i++) {
			var true_obj = obj;
			var curr_inst_index = lcgp_count; 
			var gif_src = obj.querySelector('img').getAttribute('rel:animated_src');
			
			obj.setAttribute("data-lcgp-inst", curr_inst_index);
			obj.setAttribute("data-lcgp-src", gif_src);

			obj.classList.add("lcgp_wrap", "lcgp_initialstate", 'lcgp_'+curr_inst_index);
			obj.querySelector('img').setAttribute("data-lcgp-inst", curr_inst_index);
			
			var preload 	= new Image();
			preload.parent 	= true_obj;
			preload.inst_id = curr_inst_index;
			preload.src 	= obj.querySelector('img').getAttribute('rel:animated_src');
		
			
			// gif has been loaded - execute
			preload.onload = function() {
				var that = this;
				
				// wait until plugin has been executed in there
				lcgp_init_intval[ that.inst_id ] = setInterval(function() {
					
					if( that.parent.querySelector('.jsgif') ) {
						clearInterval( lcgp_init_intval[ that.inst_id ] );
						
						setTimeout(function() {
							// apply cmds
							var cmd = document.createElement("div");  
							cmd.className = "lcpg_cmd";
							cmd.innerHTML = 
								'<span class="lcgp_play" title="play"></span>'+
								'<span class="lcgp_pause" title="pause"></span>'+
								'<span class="lcgp_stop" title="stop"></span>'+
								
								'<span class="lcgp_prev" title="hold click to move backward"></span>'+
								'<span class="lcgp_next" title="hold click to move forward"></span>'+
								
								'<span class="lcgp_enter_fs" title="enter fulscreen"></span>'+
								'<span class="lcgp_exit_fs" title="exit fullscreen"></span>';
							
							that.parent.appendChild(cmd);
							lcgp_cmds_actions(that.parent, that.inst_id);
							
							// trigger action to avoid flickering 
							lcgp_instances[ that.inst_id ].move_to(0);
						}, 30);
					}
				}, 30);
			};
			
			
			// init SuperGif plugin
			lcgp_instances[lcgp_count] = new SuperGif({ 
				gif					: obj.querySelector('img'),
				auto_play 			: false,
				progressbar_height	: 0,
				loop_mode			: false,
				rubbable			: false,
				on_end				: function(e) {
					
					var inst = e.attributes['data-lcgp-inst'].value;
					document.querySelector('.lcgp_'+ inst).querySelector('.lcgp_pause').click();
				}
			});
			
			
			// once laded - show
			lcgp_instances[lcgp_count].load(function(e) {			
				var selector = '.lcgp_'+ e.attributes['data-lcgp-inst'].value;
				
				if(document.querySelector(selector)) {
					lcgp_size_control(selector);
					document.querySelector(selector).classList.add("lcgp_loaded");
				}
			});
			
			lcgp_count++;
		}						
	};
	
	
	
	/* control size limits */
	var lcgp_size_control = function(subj) {
		var selector = (typeof(subj) != 'string') ? '.lcgp_wrap' : subj; 
		var objs = document.querySelectorAll(selector);
		
		for (var i = 0, obj; obj = objs[i]; i++) {
			
			var canvas = obj.querySelector('canvas');
			var jsgif = obj.querySelector('.jsgif');
			
			canvas.style.maxHeight 	= '';
			jsgif.style.maxHeight 	= '';
			jsgif.style.maxWidth	= '';
			
			canvas.style.maxHeight = obj.clientHeight +'px';
			
			var jsgif = obj.querySelector('.jsgif');
			jsgif.style.maxHeight = obj.clientHeight +'px';
			
			jsgif.style.maxWidth = canvas.clientWidth +'px';
		}
	}
	window.addEventListener('resize', lcgp_size_control, false);
	
	
	
	/* commands */
	var lcgp_cmds_actions = function(obj, instance_id) {
		
		// play/plause clicking on gif
		obj.addEventListener("click", function(e) {
			
			if( e.target.classList.contains('lcgp_initialstate') ) {
				this.querySelector('.lcgp_play').click();
			} 
			else if( e.target.tagName == 'CANVAS') {
				(obj.classList.contains('lcgp_paused')) ? this.querySelector('.lcgp_play').click() : this.querySelector('.lcgp_pause').click();
			} 
		});
		
		// play
		obj.querySelector('.lcgp_play').addEventListener("click", function() {
			lcgp_instances[instance_id].play();
			
			obj.classList.add("lcgp_playing");
			obj.classList.remove("lcgp_initialstate", "lcgp_paused");
		});
		
		// pause
		obj.querySelector('.lcgp_pause').addEventListener("click", function() {
			lcgp_instances[instance_id].pause();
			
			obj.classList.add("lcgp_paused");
		});
		
		// stop
		obj.querySelector('.lcgp_stop').addEventListener("click", function() {
			obj.querySelector('.lcgp_pause').click();
			lcgp_instances[instance_id].move_to(0);
			
			obj.classList.remove("lcgp_playing", "lcgp_paused");
			obj.classList.add("lcgp_initialstate");
		});
		
		
		// prev
		obj.querySelector('.lcgp_prev').addEventListener("mousedown", function() {
			obj.querySelector('.lcgp_pause').click();
			lcgp_cont_move('prev', instance_id);
		});
		obj.querySelector('.lcgp_prev').addEventListener("mouseup", function() {
			clearInterval( lcgp_cont_move[instance_id] );
		});
		
		// next
		obj.querySelector('.lcgp_next').addEventListener("mousedown", function() {
			lcgp_instances[instance_id].pause();
			lcgp_cont_move('next', instance_id);
			
			obj.classList.add("lcgp_playing", "lcgp_paused");
			obj.classList.remove("lcgp_initialstate");
		});
		obj.querySelector('.lcgp_next').addEventListener("mouseup", function() {
			clearInterval( lcgp_cont_move[instance_id] );
		});
		
		
		// enter fullscreen
		obj.querySelector('.lcgp_enter_fs').addEventListener("click", function() {
			obj.querySelector('.lcgp_pause').click();
			lcgp_enter_fs(obj, instance_id);
		});
		
		// exit fullscreen
		obj.querySelector('.lcgp_exit_fs').addEventListener("click", function() {
			document.getElementById('lcgp_fs_wrap').remove();
		});
	};
	
	
	// exit fullscreen on ESC press
	document.onkeydown = function(e) {
		if(!document.getElementById('lcgp_fs_wrap')) {return true;}
		
		e = e || window.event;
		var isEscape = false;
		
		if ("key" in e) {
			isEscape = (e.key == "Escape" || e.key == "Esc");
		} else {
			isEscape = (e.keyCode == 27);
		}
		
		if(isEscape) {
			document.getElementById('lcgp_fs_wrap').remove();
		}
	};
	
	
	
	/* continuous prev/next */
	var lcgp_cont_move = function(direction, instance_id) {
		
		if(typeof( lcgp_cont_move[instance_id] ) != 'undefined') {
			clearInterval( lcgp_cont_move[instance_id] );
		}
		
		// immediate action
		(direction == 'next') ? lcgp_instances[instance_id].move_relative(1) : lcgp_instances[instance_id].move_relative(-1);
		
		// repeating action
		lcgp_cont_move[instance_id] = setInterval(function() {
			
			(direction == 'next') ? lcgp_instances[instance_id].move_relative(1) : lcgp_instances[instance_id].move_relative(-1);
		}, 100);
	};
	
	
	
	
	/* recreate on fullscreen */
	var lcgp_enter_fs = function(obj, instance_id) {
		
		// append code to body
		var img_src = obj.attributes['data-lcgp-src'].value;
		
		var fs_code = document.createElement("div");  
		fs_code.id = "lcgp_fs_wrap";
		fs_code.innerHTML = '<div><img src="" rel:animated_src="'+ img_src +'" /></div>';
		
		document.body.appendChild(fs_code);
		
		lc_gif_player('#lcgp_fs_wrap div');
		
		
		// exit fullscreen on background click
		document.getElementById('lcgp_fs_wrap').addEventListener("click", function(e) {		
			if( e.target.id == 'lcgp_fs_wrap') {
				this.remove();
			} 
		});
	};
	
}());